///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////						
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////						
******************************************************* 6. Tables presented in the PAPER **************************************************************
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////						
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////						


clear all
set more off
use "C:\Users\sutc\Desktop\Attention to Forward Guidance\JAE.dta"

******************************************************** Global list of covariates for benchmark regressions ***************************************************************
global 	xlist		FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate)
****************************************************************************************************************************************************************************

* For the macroeconomic variables, the following convention is used throughout the paper:
* t: Current Year; t1: Next Year.
* For the interest rate variables, the following convention is used throughout the paper:
* t: 3-month forecast horizon; t1: 12-month forecast horizon.



****************************************************************************************************************************************************************************
***TABLE 1: benchmark model for paper with interactions
****************************************************************************************************************************************************************************
eststo clear
*preserve
eststo: xtreg	CE_3M_t1_D1_bps		FG_Change 	PR_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4		QE_Change 	ELB 	i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps					PR_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4		QE_Change 	///
									c.FG_Change##c.PR_D1_x4_abs	///
									c.FG_Change##c.QE_Change_abs ///
									c.FG_Change##c.ELB ///
									c.FG_Change##c.FG_ODYSSEAN_abs ///
									i.(mdate) if Year<2020, fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps					PR_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4		QE_Change 	///
									c.FG_Change##c.PR_D1_x4_abs	///
									c.FG_Change##c.QE_Change_abs ///
									c.FG_Change##c.ELB ///
									c.FG_Change##c.FG_ODYSSEAN_abs ///
									i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps					PR_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4		QE_Change 	ELB ///
									c.FG_Change##c.FG_TC_abs ///
									c.FG_Change##c.FG_SC_abs ///
									c.FG_Change##c.FG_Q_abs ///
									i.(mdate), fe vce(cluster country)

esttab using Table_Benchmark.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(	FG_Change 	PR_D1_x4 	CE_CPI_WA_D1_x4 		CE_GDP_WA_D1_x4 		QE_Change 		ELB 	///
		c.FG_Change#c.PR_D1_x4_abs ///
		c.FG_Change#c.QE_Change_abs ///
		c.FG_Change#c.ELB ///
		c.FG_Change#c.FG_ODYSSEAN_abs ///
		c.FG_Change#c.FG_TC_abs ///
		c.FG_Change#c.FG_SC_abs ///
		c.FG_Change#c.FG_Q_abs ) ///
coeflabels(	FG_Change 					"(1) Forward guidance $\{-1,0,1\}$ change ($+1$)" ///
		PR_D1_x4 						"(2) Policy rate (PR) change ($+25$ bps)" ///
		CE_CPI_WA_D1_x4 				"(3) Private inflation forecast revision ($+25$ bps)" ///
		CE_GDP_WA_D1_x4 				"(4) Private GDP growth forecast revision ($+25$ bps)" ///
		QE_Change 						"(5) Quantitative easing $\{-1,0,1\}$ change ($+1$)" ///
		ELB 							"(6) Effective lower bound $\{0,1\}$" ///
		c.FG_Change#c.PR_D1_x4_abs		"(1) x $\mid$(2)$\mid$" ///
		c.FG_Change#c.QE_Change_abs		"(1) x $\mid$(5)$\mid$" ///
		c.FG_Change#c.ELB 				"(1) x (6)" ///
		c.FG_Change#c.FG_ODYSSEAN_abs 	"(1) x Forward guidance with commitment $\{0,1\}$" ///
		c.FG_Change#c.FG_TC_abs 		"(1) x Time-contingent forward guidance $\{0,1\}$" ///
		c.FG_Change#c.FG_SC_abs 		"(1) x State-contingent forward guidance $\{0,1\}$" ///
		c.FG_Change#c.FG_Q_abs 			"(1) x Qualitative forward guidance $\{0,1\}$" ) ///
title(\textbf{How do changes in forward guidance affect revisions to individuals' forecasts of the 3-month T-bill rate in 12 months' time?} ///
		\label{tab:benchmark})	///
mtitles("[1]" "[2]" "[3]" "[4]") ///
addnote( ///
"This table shows summary statistics from panel regressions with both firm and month fixed effects." ///
"Dependent variable: revisions to individuals' forecasts of the 3-month T-bill rate in 12 months' time." ///
"Columns [1], [3], and [4] use all sample data (1990 to 2021). Column [2] omits the data from 2020-1." ///
"Baseline effects for the interaction terms are included in the regressions but are omitted here for brevity." ///
"Clustered standard errors (at the country level) are shown in parentheses.")
eststo clear
*restore
****************************************************************************************************************************************************************************


**************************************************************************************************************************************************************************
***TABLE 2: Benchmark analysis (main table) BUT with the ten-year bond yield forecasts instead (simply replace the dependent variables temporarily in the main table higher above)
************************************************************************************************************************************************************************************
eststo clear
*preserve
eststo: xtreg	CE_10Y_t1_D1_bps		FG_Change 	PR_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4		QE_Change 	ELB 	i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_10Y_t1_D1_bps					PR_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4		QE_Change 	///
									c.FG_Change##c.PR_D1_x4_abs	///
									c.FG_Change##c.QE_Change_abs ///
									c.FG_Change##c.ELB ///
									c.FG_Change##c.FG_ODYSSEAN_abs ///
									i.(mdate) if Year<2020, fe vce(cluster country)
eststo: xtreg	CE_10Y_t1_D1_bps					PR_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4		QE_Change 	///
									c.FG_Change##c.PR_D1_x4_abs	///
									c.FG_Change##c.QE_Change_abs ///
									c.FG_Change##c.ELB ///
									c.FG_Change##c.FG_ODYSSEAN_abs ///
									i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_10Y_t1_D1_bps					PR_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4		QE_Change 	ELB ///
									c.FG_Change##c.FG_TC_abs ///
									c.FG_Change##c.FG_SC_abs ///
									c.FG_Change##c.FG_Q_abs ///
									i.(mdate), fe vce(cluster country)

esttab using Table_Benchmark10Y.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(	FG_Change 	PR_D1_x4 	CE_CPI_WA_D1_x4 		CE_GDP_WA_D1_x4 		QE_Change 		ELB 	///
		c.FG_Change#c.PR_D1_x4_abs ///
		c.FG_Change#c.QE_Change_abs ///
		c.FG_Change#c.ELB ///
		c.FG_Change#c.FG_ODYSSEAN_abs ///
		c.FG_Change#c.FG_TC_abs ///
		c.FG_Change#c.FG_SC_abs ///
		c.FG_Change#c.FG_Q_abs ) ///
coeflabels(	FG_Change 					"(1) Forward guidance $\{-1,0,1\}$ change ($+1$)" ///
		PR_D1_x4 						"(2) Policy rate (PR) change ($+25$ bps)" ///
		CE_CPI_WA_D1_x4 				"(3) Private inflation forecast revision ($+25$ bps)" ///
		CE_GDP_WA_D1_x4 				"(4) Private GDP growth forecast revision ($+25$ bps)" ///
		QE_Change 						"(5) Quantitative easing $\{-1,0,1\}$ change ($+1$)" ///
		ELB 							"(6) Effective lower bound $\{0,1\}$" ///
		c.FG_Change#c.PR_D1_x4_abs		"(1) x $\mid$(2)$\mid$" ///
		c.FG_Change#c.QE_Change_abs		"(1) x $\mid$(5)$\mid$" ///
		c.FG_Change#c.ELB 				"(1) x (6)" ///
		c.FG_Change#c.FG_ODYSSEAN_abs 	"(1) x Forward guidance with commitment $\{0,1\}$" ///
		c.FG_Change#c.FG_TC_abs 		"(1) x Time-contingent forward guidance $\{0,1\}$" ///
		c.FG_Change#c.FG_SC_abs 		"(1) x State-contingent forward guidance $\{0,1\}$" ///
		c.FG_Change#c.FG_Q_abs 			"(1) x Qualitative forward guidance $\{0,1\}$" ) ///
title(\textbf{How do changes in forward guidance affect revisions to individuals' forecasts of the 3-month T-bill rate in 12 months' time?} ///
		\label{tab:benchmark})	///
mtitles("[1]" "[2]" "[3]" "[4]") ///
addnote( ///
"This table shows summary statistics from panel regressions with both firm and month fixed effects." ///
"Dependent variable: revisions to individuals' forecasts of the 10-year bond yield in 12 months' time." ///
"Columns [1], [3], and [4] use all sample data (1990 to 2021). Column [2] omits the data from 2020-1." ///
"Baseline effects for the interaction terms are included in the regressions but are omitted here for brevity." ///
"Clustered standard errors (at the country level) are shown in parentheses.")
eststo clear
*restore
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE 3: Interest Rate Expectations and FG (Term Structure)
****************************************************************************************************************************************************************************
eststo clear
eststo: xtreg	CE_3M_t_D1_bps		FG_Change	CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps		FG_Change	CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_10Y_t_D1_bps		FG_Change	CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_10Y_t1_D1_bps	FG_Change	CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4	PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)

esttab using Table_FG_Term_Structure.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		FG_Change	) ///
coeflabels(	FG_Change			"Forward guidance (FG) $\{-1,0,1\}$ change" ///
						) ///
title(\textbf{How Forward Guidance Affects T-Bill and Bond Yield Expectations at Different Forecast Horizons} ///
\label{tab:FGTS})	///
mtitles("[1]" "[2]" "[3]" "[4]") ///
addnote( ///
"Dependent variable [1]: revisions to individuals' forecasts, 3-month T-bill rate in 3 months (bps)." ///
"Dependent variable [2]: revisions to individuals' forecasts, 3-month T-bill rate in 12 months (bps)." ///
"Dependent variable [3]: revisions to individuals' forecasts, 10-year bond yield in 3 months (bps)." ///
"Dependent variable [4]: revisions to individuals' forecasts, 10-year bond yield in 12 months (bps)." ///
"Regressions include all controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
*********************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE 4: How Forward Guidance Affected Interest Rate Expectations in Different Periods
****************************************************************************************************************************************************************************
eststo clear
*preserve
eststo: xtreg	CE_3M_t1_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year<1999, fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year>1998 & Year<2006, fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year>2005 & Year<2013, fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year>2012, fe vce(cluster country)
*restore

esttab using Table_FG_Subsamples.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		FG_Change	) ///
coeflabels(	FG_Change			"Forward guidance (FG) $\{-1,0,1\}$ change" ///
						) ///
title(\textbf{How Forward Guidance Affected Interest Rate Expectations in Different Periods} ///
\label{tab:FGSS})	///
mtitles("[1]" "[2]" "[3]" "[4]") ///
addnote( ///
"[1]: 1990 to 1998; [2]: 1999 to 2005; [3]: 2006 to 2012; [4] 2013 to 2021." ///
"Regressions include all controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
*********************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE 5: Interest Rate Expectations and Central Bank Information Effects
****************************************************************************************************************************************************************************
eststo clear
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4, fe vce(cluster country)
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year<2007, fe vce(cluster country)
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year>2006 & Year<2015, fe vce(cluster country)
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year>2014, fe vce(cluster country)
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if FG_Change==0 & PR_D1_x4==0 & QE_Change==0, fe vce(cluster country)


esttab using Table_IE.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change ///
			) ///
coeflabels(	///
			CB_CPI_WA_D1_x4  							"CB $\pi$ revision (+25 bps)" ///
			CB_GDP_WA_D1_x4  							"CB GDP g rev. (+25 bps)" ///
			CE_CPI_WA_D1_x4  							"Indiv. $\pi$ rev. (+25 bps)" ///
			CE_GDP_WA_D1_x4  							"Indiv. GDP g rev. (+25 bps)" ///
			FG_Change									"FG $\{-1,0,1\}$ change" ///
			) ///
title(\textbf{Interest Rate Expectations and Central Bank (CB) Information Effects} ///
\label{tab:CBIE})	///
mtitles("[1]" "[2]" "[3]" "[4]" "[5]" "[6]") ///
addnote( ///
"Dependent variables [1]-[6]: revisions to individuals' forecasts, 3-month T-bill rate in 12 months (bps)." ///
"Columns [1]-[2]: full sample (all 12 countries); [3]: 1990-2006; [4]: 2007-2014; [5]: 2015-2021." ///
"Column [6]: subsample, periods with no policy rate change, no FG change, and no QE change." ///
"Regressions [2]-[6] include all controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
*OA Robustness (exclude periods in which the central bank used an endogenous policy rate to produce its projections):  if PRA_E==0
****************************************************************************************************************************************************************************







///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////						
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////						
******************************************************* 7. Tables presented in the ONLINE APPENDIX ****************************************************
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////						
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////						


******************************************************* 7a. Robustness presented in the ONLINE APPENDIX ****************************************************


****************************************************************************************************************************************************************************
***TABLE A3: Benchmark: drop any instances of a forward guidance change when it was too close to a Consensus Economics survey date
preserve
*Count the number of observations in the sample data that correspond to nonzero values of changes in forward guidance (2362)
drop if FG_Change!=0
restore
eststo clear
preserve
*560/2362; 5.5
drop if FG_Change!=0 & Delta_CE_FG<6
eststo:		xtreg	CE_3M_t1_D1_bps		FG_Change PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
restore
preserve
*680/2362; 4.5
drop if FG_Change!=0 & Delta_CE_FG<11
eststo:		xtreg	CE_3M_t1_D1_bps		FG_Change PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
restore
preserve
*1096/2362; 4.1
drop if FG_Change!=0 & Delta_CE_FG<16
eststo:		xtreg	CE_3M_t1_D1_bps		FG_Change PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
restore
preserve
drop if FG_Change!=0 & Delta_CE_FG>15
*1536/2362; 6.8
eststo:		xtreg	CE_3M_t1_D1_bps		FG_Change PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
restore

esttab using Table_FG_Dates.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(	FG_Change 	PR_D1_x4 	CE_CPI_WA_D1_x4 		CE_GDP_WA_D1_x4 		QE_Change 		ELB 	) ///
coeflabels(	FG_Change 					"(1) Forward guidance $\{-1,0,1\}$ change ($+1$)" ///
		PR_D1_x4 						"(2) Policy rate (PR) change ($+25$ bps)" ///
		CE_CPI_WA_D1_x4 				"(3) Private inflation forecast revision ($+25$ bps)" ///
		CE_GDP_WA_D1_x4 				"(4) Private GDP growth forecast revision ($+25$ bps)" ///
		QE_Change 						"(5) Quantitative easing $\{-1,0,1\}$ change ($+1$)" ///
		ELB 							"(6) Effective lower bound $\{0,1\}$" ) ///
title(\textbf{Benchmark econometric model with variations in the allowed gap between FG announcement dates and Consensus Economics survey dates} ///
		\label{tab:Robust_FGdates})	///
mtitles("[1]" "[2]" "[3]" "[4]") ///
addnote( ///
"Dependent variable: revisions to individuals' forecasts of the 3-month T-bill rate in 12 months (bps)." ///
"[1] Benchmark after dropping observations with FG changes that occur within 6 days of a CE survey deadline." ///
"[2] Benchmark after dropping observations with FG changes that occur within 11 days of a CE survey deadline." ///
"[3] Benchmark after dropping observations with FG changes that occur within 16 days of a CE survey deadline." ///
"[4] Benchmark after dropping observations with FG changes that occur more than 15 days before a CE survey." ///
"Clustered standard errors (at the country level) are shown in parentheses." ///
"This table shows summary statistics from panel regressions with both firm and month fixed effects.")
eststo clear
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***Table A4: Comparing consensus forecasts to individual forecasts
***Benchmark regression model but with mean variables
*********Benchmark regression
eststo clear
eststo:		xtreg		CE_3M_t1_D1_bps			FG_Change 	CE_CPI_WA_D1_x4 		CE_GDP_WA_D1_x4 		PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo:		xtreg		CE_3M_t1_D1_bps_mean	FG_Change 	CE_CPI_WA_D1_x4_mean 	CE_GDP_WA_D1_x4_mean 	PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)

esttab using Table_Means.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(	FG_Change  	CE_CPI_WA_D1_x4 		CE_GDP_WA_D1_x4 		CE_CPI_WA_D1_x4_mean 	CE_GDP_WA_D1_x4_mean ///
		PR_D1_x4	QE_Change 		ELB   ) ///
coeflabels(	FG_Change 					"Forward guidance $\{-1,0,1\}$ change ($+1$)" ///
		CE_CPI_WA_D1_x4 				"Private inflation forecast revision ($+25$ bps)" ///
		CE_GDP_WA_D1_x4 				"Private GDP growth forecast revision ($+25$ bps)" ///
		CE_CPI_WA_D1_x4_mean			"Mean private inflation forecast revision" ///
		CE_GDP_WA_D1_x4_mean			"Mean private GDP growth forecast revision" ///
		PR_D1_x4 						"Policy rate change ($+25$ bps)" ///
		QE_Change 						"Quantitative easing $\{-1,0,1\}$ change ($+1$)" ///
		ELB 							"Effective lower bound $\{0,1\}$" 	) ///
title(\textbf{Benchmark results after averaging individual forecaster data across forecasters} ///
		\label{tab:Robust_Means})	///
mtitles("[1]" "[2]") ///
addnote( ///
"Dependent variable [1]: revisions to individuals' forecasts of the 3-month T-bill rate in 12 months (bps)." ///
"Dependent variable [2]: the country-specific, month-specific \textbf{mean} of dependent variable [1]." ///
"In [2], the mean inflation and growth forecast revisions were also averaged by country, by month." ///
"Clustered standard errors (country level) in parentheses. Includes both firm and month fixed effects." )
eststo clear
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE A5: Interest Rate Expectations and Central Bank Information Effects (excluding projections that use an endogenous policy rate)
****************************************************************************************************************************************************************************
eststo clear
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 if PRA_E==0, fe vce(cluster country)
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if PRA_E==0, fe vce(cluster country)

esttab using Table_IE.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep( CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change ///
			) ///
coeflabels(	///
			CB_CPI_WA_D1_x4  							"CB inflation revision (+25 bps)" ///
			CB_GDP_WA_D1_x4  							"CB GDP growth revision (+25 bps)" ///
			CE_CPI_WA_D1_x4  							"Indiv. inflation revision (+25 bps)" ///
			CE_GDP_WA_D1_x4  							"Indiv. GDP growth revision (+25 bps)" ///
			FG_Change									"FG $\{-1,0,1\}$ change" ///
			) ///
title(\textbf{Central Bank (CB) Information Effects (excluding projections that use an endogenous policy rate)} ///
\label{tab:CBIEPRANE})	///
mtitles("[1]" "[2]") ///
addnote( ///
"Dependent variables [1]-[2]: revisions to individuals' forecasts, 3-month T-bill rate in 12 months (bps)." ///
"Regressions [1]-[2] include all controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE A6: The role of interest rate forecast disagreement in the transmission of forward guidance to interest-rate expectation formation
****************************************************************************************************************************************************************************

eststo clear
eststo: xtreg	CE_3M_t1_D1_bps		c.FG_Change##c.VU 								CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps		c.FG_Change##c.VU##c.CE_3M_t1_bps_sd_std_L1 	CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps		c.FG_Change##c.CE_3M_t1_bps_sd_std_L1 ///
									c.CE_CPI_WA_D1_x4##c.CE_3M_t1_bps_sd_std_L1 	c.CE_GDP_WA_D1_x4##c.CE_3M_t1_bps_sd_std_L1 ///
									c.CB_CPI_WA_D1_x4##c.CE_3M_t1_bps_sd_std_L1 	c.CB_GDP_WA_D1_x4##c.CE_3M_t1_bps_sd_std_L1 ///
									PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)

esttab using Table_VU_Disagreement_IE.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		FG_Change	VU 	CE_3M_t1_bps_sd_std_L1 ///
			CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 ///
			CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 ///
			c.FG_Change#c.VU ///
			c.FG_Change#c.CE_3M_t1_bps_sd_std_L1 ///
			c.VU#c.CE_3M_t1_bps_sd_std_L1 ///
			c.FG_Change#c.VU#c.CE_3M_t1_bps_sd_std_L1 ///
			c.CE_CPI_WA_D1_x4#c.CE_3M_t1_bps_sd_std_L1 	c.CE_GDP_WA_D1_x4#c.CE_3M_t1_bps_sd_std_L1 ///
			c.CB_CPI_WA_D1_x4#c.CE_3M_t1_bps_sd_std_L1 	c.CB_GDP_WA_D1_x4#c.CE_3M_t1_bps_sd_std_L1 ///
			) ///
coeflabels(	FG_Change 									"(1) Forward guidance (FG) $\{-1,0,1\}$ change" ///
			VU											"(2) Very unexpected FG change $\{0,1\}$" ///
			CE_3M_t1_bps_sd_std_L1						"(3) Lagged interest rate disagreement ($\sigma_{t-1}$)" ///
			CE_CPI_WA_D1_x4 							"(4) Private inflation forecast revision ($+25$ bps)" ///
			CE_GDP_WA_D1_x4 							"(5) Private GDP growth forecast revision ($+25$ bps)" ///
			CB_CPI_WA_D1_x4  							"(6) Central bank inflation revision (+25 bps)" ///
			CB_GDP_WA_D1_x4  							"(7) Central bank GDP growth revision (+25 bps)" ///
			c.FG_Change#c.VU			 				"(1) x (2)" ///
			c.FG_Change#c.CE_3M_t1_bps_sd_std_L1		"(1) x (3)" ///
			c.VU#c.CE_3M_t1_bps_sd_std_L1				"(2) x (3)" ///
			c.FG_Change#c.VU#c.CE_3M_t1_bps_sd_std_L1	"(1) x (2) x (3)"  ///
			c.CE_CPI_WA_D1_x4#c.CE_3M_t1_bps_sd_std_L1 	"(3) x (4)" ///
			c.CE_GDP_WA_D1_x4#c.CE_3M_t1_bps_sd_std_L1 	"(3) x (5)" ///
			c.CB_CPI_WA_D1_x4#c.CE_3M_t1_bps_sd_std_L1 	"(3) x (6)" ///	
			c.CB_GDP_WA_D1_x4#c.CE_3M_t1_bps_sd_std_L1 	"(3) x (7)" ///
			) ///
title(\textbf{Unanticipated forward guidance, interest rate forecast disagreement, and central bank information effects} ///
\label{tab:VUFGCBIE})	///
mtitles("[1]" "[2]" "[3]") ///
addnote( ///
"Dependent variables [1]-[3]: revisions to individuals' forecasts, 3-month T-bill rate in 12 months (bps)." ///
"Regressions include all controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
*********************************************************************************************************************************



****************************************************************************************************************************************************************************
***TABLE A7: System GMM estimation (Arellano and Bond Estimator)
eststo clear
mata: mata set matafavor speed
*Static model
eststo: xtabond2	CE_3M_t1_D1_bps FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 QE_Change PR_D1_x4 ELB i.(mdate), ///
cluster(country) /// 
small ///
ivstyle(PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 ELB i.(mdate), equation(diff)) ///
gmmstyle(FG_Change QE_Change, laglimits(1 5) collapse equation(diff)) robust
*Dynamic model
eststo: xtabond2	CE_3M_t1_D1_bps FG_Change CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4 QE_Change PR_D1_x4 ELB L1.CE_3M_t1_D1_bps i.(mdate), ///
cluster(country) /// 
small ///
ivstyle(PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 ELB i.(mdate), equation(diff)) ///
gmmstyle(L1.CE_3M_t1_D1_bps FG_Change QE_Change, laglimits(1 5) collapse equation(diff)) robust
*No time dummies
eststo: xtabond2	CE_3M_t1_D1_bps FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 QE_Change PR_D1_x4 ELB, ///
cluster(country) /// 
small ///
ivstyle(PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 ELB, equation(diff)) ///
gmmstyle(FG_Change QE_Change, laglimits(1 5) collapse equation(diff)) robust


esttab using Table_GMM.tex, ///
replace b(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01)  ///
keep(FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 QE_Change PR_D1_x4 ELB L.CE_3M_t1_D1_bps) ///
coeflabels(	FG_Change 		"Forward guidance $\{-1,0,1\}$ change ($+1$)" ///
		PR_D1_x4 			"Policy rate (PR) change ($+25$ bps)" ///
		ELB					"Effective lower bound (ELB)" ///
		CE_CPI_WA_D1_x4 	"Private inflation forecast revision ($+25$ bps)" ///
		CE_GDP_WA_D1_x4 	"Private domestic output forecast revision ($+25$ bps)" ///
		QE_Change 			"Quantitative easing $\{-1,0,1\}$ change ($+1$)" ///
		L.CE_3M_t1_D1_bps	"Lagged dependent variable" ) ///
title(\textbf{GMM estimation of the benchmark results} ///
		\label{GMM})	///
mtitles("[1]" "[2]" "[3]") ///
addnote( ///
"Dependent variable: revisions to individuals' forecasts of the 3-month T-bill rate in 12 months (bps)." ///
"Clustered standard errors (at the country level) are shown in parentheses.")
eststo clear
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE A8: Omitted Variable Bias Analysis
****************************************************************************************************************************************************************************
eststo clear
eststo: xtreg	CE_3M_t1_D1_bps		CE_CPI_t_D1_x4		CE_CPI_t1_D1_x4 	CE_GDP_t_D1_x4  	CE_GDP_t1_D1_x4		FG_Change 	PR_D1_x4 	ELB 	QE_Change 	i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps		CE_CPI_WA_D1_x4  	CE_GDP_WA_D1_x4												FG_Change 	PR_D1_x4 	ELB 	QE_Change 	i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps		CE_CPI_WA_D1_x4  																FG_Change 	PR_D1_x4 	ELB 	QE_Change 	i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps		CE_GDP_WA_D1_x4  																FG_Change 	PR_D1_x4 	ELB 	QE_Change 	i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps																						FG_Change 	PR_D1_x4 	ELB 	QE_Change 	i.(mdate), fe vce(cluster country)

esttab using Table_FG_OVB.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(FG_Change 	CE_CPI_t_D1_x4		CE_CPI_t1_D1_x4 	CE_GDP_t_D1_x4  	CE_GDP_t1_D1_x4		CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 	PR_D1_x4 QE_Change  ///
			) ///
coeflabels(	///
			FG_Change									"(1) FG $\{-1,0,1\}$ change" ///
			CE_CPI_t_D1_x4								"Current-year $\pi$ rev. (+25 bps)" ///
			CE_CPI_t1_D1_x4 							"Next-year $\pi$ rev. (+25 bps)" ///
			CE_GDP_t_D1_x4  							"Current-year GDP g rev. (+25 bps)" ///
			CE_GDP_t1_D1_x4								"Next-year GDP g rev. (+25 bps)" ///
			CE_CPI_WA_D1_x4  							"12-month $\pi$ rev. (+25 bps)" ///
			CE_GDP_WA_D1_x4  							"12-month GDP g rev. (+25 bps)" ///
			PR_D1_x4 									"CB rate change (+25 bps)" ///
			QE_Change 									"QE $\{-1,0,1\}$ change ($+1$)" ///
			) ///
title(\textbf{Benchmark Model with Different Macroeconomic Controls} ///
\label{tab:FGOVB}) ///
mtitles("[1]" "[2]" "[3]" "[4]" "[5]") ///
addnote( ///
"Dependent variables [1]-[5]: revisions to individuals' forecasts of the 3-month T-bill rate in 12 months (bps)." ///
"Regressions [1]-[5] include all other controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
****************************************************************************************************************************************************************************



******************************************************* 7b. Additional Results presented in the ONLINE APPENDIX ****************************************************


**********

****************************************************************************************************************************************************************************
***TABLE A9: Term Structure of Interest Rate Expectations and Central Bank Information Effects
****************************************************************************************************************************************************************************
eststo clear
eststo: xtreg	CE_3M_t_D1_bps		FG_Change	CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 	CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 	PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps		FG_Change	CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 	CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 	PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_10Y_t_D1_bps		FG_Change	CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 	CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 	PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_10Y_t1_D1_bps	FG_Change	CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 	CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 	PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)

esttab using Table_Information_Effects_Rates.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		FG_Change	CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 	CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 ) ///
coeflabels(	FG_Change			"(1) Forward guidance (FG) $\{-1,0,1\}$ change" ///
			CE_CPI_WA_D1_x4  	"(2) Individual inflation revision (+25 bps)" ///
			CE_GDP_WA_D1_x4  	"(3) Individual GDP growth revision (+25 bps)" ///
			CB_CPI_WA_D1_x4  	"(4) Central bank inflation revision (+25 bps)" ///
			CB_GDP_WA_D1_x4  	"(5) Central bank GDP growth revision (+25 bps)" ///
						) ///
title(\textbf{Interest Rate Expectations and Central Bank Information Effects} ///
\label{tab:CBIEIRE})	///
mtitles("[1]" "[2]" "[3]" "[4]") ///
addnote( ///
"Dependent variable [1]: revisions to individuals' forecasts, 3-month T-bill rate in 3 months (bps)." ///
"Dependent variable [2]: revisions to individuals' forecasts, 3-month T-bill rate in 12 months (bps)." ///
"Dependent variable [3]: revisions to individuals' forecasts, 10-year bond yield in 3 months (bps)." ///
"Dependent variable [4]: revisions to individuals' forecasts, 10-year bond yield in 12 months (bps)." ///
"Standard errors clustered at the country level. Regressions include all controls from \autoref{eqn:Benchmark}." )
eststo clear
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE A10: Interest Rate Expectations and Central Bank Information Effects, CE_3M_t_D1_bps 
****************************************************************************************************************************************************************************
eststo clear
eststo: xtreg CE_3M_t_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4, fe vce(cluster country)
eststo: xtreg CE_3M_t_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg CE_3M_t_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year<2007, fe vce(cluster country)
eststo: xtreg CE_3M_t_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year>2006 & Year<2015, fe vce(cluster country)
eststo: xtreg CE_3M_t_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year>2014, fe vce(cluster country)
eststo: xtreg CE_3M_t_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if FG_Change==0 & PR_D1_x4==0 & QE_Change==0, fe vce(cluster country)


esttab using Table_IE_3M_t.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change ///
			) ///
coeflabels(	///
			CB_CPI_WA_D1_x4  							"CB $\pi$ revision (+25 bps)" ///
			CB_GDP_WA_D1_x4  							"CB GDP g rev. (+25 bps)" ///
			CE_CPI_WA_D1_x4  							"Indiv. $\pi$ rev. (+25 bps)" ///
			CE_GDP_WA_D1_x4  							"Indiv. GDP g rev. (+25 bps)" ///
			FG_Change									"FG $\{-1,0,1\}$ change" ///
			) ///
title(\textbf{Interest Rate Expectations and Central Bank (CB) Information Effects (3M)} ///
\label{tab:CBIE3Mt})	///
mtitles("[1]" "[2]" "[3]" "[4]" "[5]" "[6]") ///
addnote( ///
"Dependent variables [1]-[6]: revisions to individuals' forecasts, 3-month T-bill rate in 3 months (bps)." ///
"Columns [1]-[2]: full sample; column [3]: 1990-2006; column [4]: 2007-2014; column [5]: 2015-2021." ///
"Column [6]: subsample, periods with no policy rate change, no FG change, and no QE change." ///
"Regressions [2]-[6] include all controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
*OA Robustness (exclude periods in which the central bank used an endogenous policy rate to produce its projections):  if PRA_E==0
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE A11: Interest Rate Expectations and Central Bank Information Effects, CE_3M_t1_D1_bps 
****************************************************************************************************************************************************************************
eststo clear
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4, fe vce(cluster country)
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year<2007, fe vce(cluster country)
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year>2006 & Year<2015, fe vce(cluster country)
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year>2014, fe vce(cluster country)
eststo: xtreg CE_3M_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if FG_Change==0 & PR_D1_x4==0 & QE_Change==0, fe vce(cluster country)


esttab using Table_IE_3M_t1.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change ///
			) ///
coeflabels(	///
			CB_CPI_WA_D1_x4  							"CB $\pi$ revision (+25 bps)" ///
			CB_GDP_WA_D1_x4  							"CB GDP g rev. (+25 bps)" ///
			CE_CPI_WA_D1_x4  							"Indiv. $\pi$ rev. (+25 bps)" ///
			CE_GDP_WA_D1_x4  							"Indiv. GDP g rev. (+25 bps)" ///
			FG_Change									"FG $\{-1,0,1\}$ change" ///
			) ///
title(\textbf{Interest Rate Expectations and Central Bank (CB) Information Effects (12M)} ///
\label{tab:CBIE3Mt1})	///
mtitles("[1]" "[2]" "[3]" "[4]" "[5]" "[6]") ///
addnote( ///
"Dependent variables [1]-[6]: revisions to individuals' forecasts, 3-month T-bill rate in 12 months (bps)." ///
"Columns [1]-[2]: full sample; column [3]: 1990-2006; column [4]: 2007-2014; column [5]: 2015-2021." ///
"Column [6]: subsample, periods with no policy rate change, no FG change, and no QE change." ///
"Regressions [2]-[6] include all controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
*OA Robustness (exclude periods in which the central bank used an endogenous policy rate to produce its projections):  if PRA_E==0
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE A12: Interest Rate Expectations and Central Bank Information Effects, CE_10Y_t_D1_bps
****************************************************************************************************************************************************************************
eststo clear
eststo: xtreg CE_10Y_t_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4, fe vce(cluster country)
eststo: xtreg CE_10Y_t_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg CE_10Y_t_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year<2007, fe vce(cluster country)
eststo: xtreg CE_10Y_t_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year>2006 & Year<2015, fe vce(cluster country)
eststo: xtreg CE_10Y_t_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year>2014, fe vce(cluster country)
eststo: xtreg CE_10Y_t_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if FG_Change==0 & PR_D1_x4==0 & QE_Change==0, fe vce(cluster country)


esttab using Table_IE_10Y_t.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change ///
			) ///
coeflabels(	///
			CB_CPI_WA_D1_x4  							"CB $\pi$ revision (+25 bps)" ///
			CB_GDP_WA_D1_x4  							"CB GDP g rev. (+25 bps)" ///
			CE_CPI_WA_D1_x4  							"Indiv. $\pi$ rev. (+25 bps)" ///
			CE_GDP_WA_D1_x4  							"Indiv. GDP g rev. (+25 bps)" ///
			FG_Change									"FG $\{-1,0,1\}$ change" ///
			) ///
title(\textbf{Ten-Year Bond Yield Expectations and Central Bank (CB) Information Effects (3M)} ///
\label{tab:CBIETENYRI}) ///
mtitles("[1]" "[2]" "[3]" "[4]" "[5]" "[6]") ///
addnote( ///
"Dependent variables [1]-[6]: revisions to individuals' forecasts, 10-year bond yield in 3 months (bps)." ///
"Columns [1]-[2]: full sample; column [3]: 1990-2006; column [4]: 2007-2014; column [5]: 2015-2021." ///
"Column [6]: subsample, periods with no policy rate change, no FG change, and no QE change." ///
"Regressions [2]-[6] include all controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
*OA Robustness (exclude periods in which the central bank used an endogenous policy rate to produce its projections):  if PRA_E==0
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE A13: Interest Rate Expectations and Central Bank Information Effects, CE_10Y_t1_D1_bps
****************************************************************************************************************************************************************************
eststo clear
eststo: xtreg CE_10Y_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4, fe vce(cluster country)
eststo: xtreg CE_10Y_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg CE_10Y_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year<2007, fe vce(cluster country)
eststo: xtreg CE_10Y_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year>2006 & Year<2015, fe vce(cluster country)
eststo: xtreg CE_10Y_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if Year>2014, fe vce(cluster country)
eststo: xtreg CE_10Y_t1_D1_bps CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 QE_Change ELB i.(mdate) if FG_Change==0 & PR_D1_x4==0 & QE_Change==0, fe vce(cluster country)


esttab using Table_IE_10Y_t1.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change ///
			) ///
coeflabels(	///
			CB_CPI_WA_D1_x4  							"CB $\pi$ revision (+25 bps)" ///
			CB_GDP_WA_D1_x4  							"CB GDP g rev. (+25 bps)" ///
			CE_CPI_WA_D1_x4  							"Indiv. $\pi$ rev. (+25 bps)" ///
			CE_GDP_WA_D1_x4  							"Indiv. GDP g rev. (+25 bps)" ///
			FG_Change									"FG $\{-1,0,1\}$ change" ///
			) ///
title(\textbf{Ten-Year Bond Yield Expectations and Central Bank (CB) Information Effects (12M)} ///
\label{tab:CBIETENYRII}) ///
mtitles("[1]" "[2]" "[3]" "[4]" "[5]" "[6]") ///
addnote( ///
"Dependent variables [1]-[6]: revisions to individuals' forecasts, 10-year bond yield in 12 months (bps)." ///
"Columns [1]-[2]: full sample; column [3]: 1990-2006; column [4]: 2007-2014; column [5]: 2015-2021." ///
"Column [6]: subsample, periods with no policy rate change, no FG change, and no QE change." ///
"Regressions [2]-[6] include all controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
*OA Robustness (exclude periods in which the central bank used an endogenous policy rate to produce its projections):  if PRA_E==0
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE A14: CE Expectations and Central Bank Information Effects, elb vs non-elb
****************************************************************************************************************************************************************************
eststo clear
eststo: xtreg 	CE_3M_t1_D1_bps 	CB_CPI_WA_D1_x4 	CB_GDP_WA_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4 	FG_Change 	PR_D1_x4 	QE_Change 	ELB 	i.(mdate), 				fe vce(cluster country)
eststo: xtreg 	CE_3M_t1_D1_bps 	CB_CPI_WA_D1_x4 	CB_GDP_WA_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4 	FG_Change 	PR_D1_x4 	QE_Change 	ELB 	i.(mdate) if ELB==0, 	fe vce(cluster country)
eststo: xtreg 	CE_3M_t1_D1_bps 	CB_CPI_WA_D1_x4 	CB_GDP_WA_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4 	FG_Change 	PR_D1_x4 	QE_Change 	ELB 	i.(mdate) if ELB==1, 	fe vce(cluster country)
eststo: xtreg 	CE_10Y_t1_D1_bps 	CB_CPI_WA_D1_x4 	CB_GDP_WA_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4 	FG_Change 	PR_D1_x4 	QE_Change 	ELB 	i.(mdate), 				fe vce(cluster country)
eststo: xtreg 	CE_10Y_t1_D1_bps 	CB_CPI_WA_D1_x4 	CB_GDP_WA_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4 	FG_Change 	PR_D1_x4 	QE_Change 	ELB 	i.(mdate) if ELB==0, 	fe vce(cluster country)
eststo: xtreg 	CE_10Y_t1_D1_bps 	CB_CPI_WA_D1_x4 	CB_GDP_WA_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4 	FG_Change 	PR_D1_x4 	QE_Change 	ELB 	i.(mdate) if ELB==1, 	fe vce(cluster country)

esttab using Table_IE_ELB.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 	QE_Change  ///
			) ///
coeflabels(	///
			CB_CPI_WA_D1_x4  							"CB $\pi$ revision (+25 bps)" ///
			CB_GDP_WA_D1_x4  							"CB GDP g rev. (+25 bps)" ///
			CE_CPI_WA_D1_x4  							"Indiv. $\pi$ rev. (+25 bps)" ///
			CE_GDP_WA_D1_x4  							"Indiv. GDP g rev. (+25 bps)" ///
			FG_Change									"FG $\{-1,0,1\}$ change" ///
			PR_D1_x4 									"CB rate change (+25 bps)" ///
			QE_Change 									"QE $\{-1,0,1\}$ change ($+1$)" ///
			) ///
title(\textbf{Interest Rate Expectations at and away from the Effective Lower Bound} ///
\label{tab:CBIEelb}) ///
mtitles("[1]" "[2]" "[3]" "[4]" "[5]" "[6]") ///
addnote( ///
"Dependent variable [1]: revisions to 3-month T-Bill forecasts over the next 12 months (bps), full sample." 		///
"Dependent variable [2]: revisions to 3-month T-Bill forecasts over the next 12 months (bps), away from ELB." 		///
"Dependent variable [3]: revisions to 3-month T-Bill forecasts over the next 12 months (bps), at the ELB." 			///
"Dependent variable [4]: revisions to 10-year T-Bond forecasts over the next 12 months (bps), full sample." 		///
"Dependent variable [5]: revisions to 10-year T-Bond forecasts over the next 12 months (bps), away from ELB." 		///
"Dependent variable [6]: revisions to 10-year T-Bond forecasts over the next 12 months (bps), at the ELB." 			///
"Regressions [1]-[6] include controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE A15: CE Expectations and Central Bank Information Effects, CE_CPI_WA_D1_bps CE_GDP_WA_D1_bps
****************************************************************************************************************************************************************************
eststo clear
eststo: xtreg	CE_CPI_WA_D1_bps 	CE_GDP_WA_D1_x4 	CB_CPI_WA_D1_x4 	CB_GDP_WA_D1_x4		FG_Change 	PR_D1_x4 	QE_Change 	ELB 	i.(mdate), 				fe vce(cluster country)
eststo: xtreg	CE_CPI_WA_D1_bps 	CE_GDP_WA_D1_x4 	CB_CPI_WA_D1_x4 	CB_GDP_WA_D1_x4		FG_Change 	PR_D1_x4 	QE_Change 			i.(mdate) if ELB==0, 	fe vce(cluster country)
eststo: xtreg	CE_CPI_WA_D1_bps 	CE_GDP_WA_D1_x4 	CB_CPI_WA_D1_x4 	CB_GDP_WA_D1_x4		FG_Change 	PR_D1_x4 	QE_Change 			i.(mdate) if ELB==1, 	fe vce(cluster country)
eststo: xtreg	CE_GDP_WA_D1_bps 	CE_CPI_WA_D1_x4		CB_CPI_WA_D1_x4 	CB_GDP_WA_D1_x4		FG_Change 	PR_D1_x4 	QE_Change 	ELB 	i.(mdate), 				fe vce(cluster country)
eststo: xtreg	CE_GDP_WA_D1_bps 	CE_CPI_WA_D1_x4 	CB_CPI_WA_D1_x4 	CB_GDP_WA_D1_x4		FG_Change 	PR_D1_x4 	QE_Change 			i.(mdate) if ELB==0, 	fe vce(cluster country)
eststo: xtreg	CE_GDP_WA_D1_bps 	CE_CPI_WA_D1_x4 	CB_CPI_WA_D1_x4 	CB_GDP_WA_D1_x4		FG_Change 	PR_D1_x4 	QE_Change 			i.(mdate) if ELB==1, 	fe vce(cluster country)

esttab using Table_IE_Macro.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 FG_Change PR_D1_x4 	QE_Change  ///
			) ///
coeflabels(	///
			CB_CPI_WA_D1_x4  							"CB $\pi$ revision (+25 bps)" ///
			CB_GDP_WA_D1_x4  							"CB GDP g rev. (+25 bps)" ///
			CE_CPI_WA_D1_x4  							"Indiv. $\pi$ rev. (+25 bps)" ///
			CE_GDP_WA_D1_x4  							"Indiv. GDP g rev. (+25 bps)" ///
			FG_Change									"FG $\{-1,0,1\}$ change" ///
			PR_D1_x4 									"CB rate change (+25 bps)" ///
			QE_Change 									"QE $\{-1,0,1\}$ change ($+1$)" ///
			) ///
title(\textbf{Private-Sector Forecaster Inflation and Growth Expectations and Central Bank (CB) Information Effects} ///
\label{tab:CBIEmacro}) ///
mtitles("[1]" "[2]" "[3]" "[4]" "[5]" "[6]") ///
addnote( ///
"Dependent variable [1]: revisions to individual $\pi$ forecasts over the next 12 months (bps), full sample." 		///
"Dependent variable [2]: revisions to individual $\pi$ forecasts over the next 12 months (bps), away from ELB." 	///
"Dependent variable [3]: revisions to individual $\pi$ forecasts over the next 12 months (bps), at the ELB." 		///
"Dependent variable [4]: revisions to individual growth forecasts over the next 12 months (bps), full sample." 		///
"Dependent variable [5]: revisions to individual growth forecasts over the next 12 months (bps), away from ELB." 	///
"Dependent variable [6]: revisions to individual growth forecasts over the next 12 months (bps), at the ELB." 		///
"Regressions [1]-[6] include the controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
*OA Robustness (exclude periods in which the central bank used an endogenous policy rate to produce its projections):  if PRA_E==0
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE A16: Term Structure of The role of interest rate forecast disagreement in the transmission of FG to interest-rate expectation formation
****************************************************************************************************************************************************************************

eststo clear
eststo: xtreg	CE_3M_t_D1_bps		c.FG_Change##c.VU##c.CE_3M_t_bps_sd_std_L1 		PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_3M_t1_D1_bps		c.FG_Change##c.VU##c.CE_3M_t1_bps_sd_std_L1 	PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_10Y_t_D1_bps		c.FG_Change##c.VU##c.CE_10Y_t_bps_sd_std_L1 	PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
eststo: xtreg	CE_10Y_t1_D1_bps	c.FG_Change##c.VU##c.CE_10Y_t1_bps_sd_std_L1	PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)

esttab using Table_VU_Disagreement.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		FG_Change	VU 	CE_3M_t_bps_sd_std_L1 CE_3M_t1_bps_sd_std_L1 CE_10Y_t_bps_sd_std_L1 CE_10Y_t1_bps_sd_std_L1 ///
			c.FG_Change#c.VU ///
			c.FG_Change#c.CE_3M_t_bps_sd_std_L1 ///
			c.FG_Change#c.CE_3M_t1_bps_sd_std_L1 ///
			c.FG_Change#c.CE_10Y_t_bps_sd_std_L1 ///
			c.FG_Change#c.CE_10Y_t1_bps_sd_std_L1 ///
			c.VU#c.CE_3M_t_bps_sd_std_L1 ///
			c.VU#c.CE_3M_t1_bps_sd_std_L1 ///
			c.VU#c.CE_10Y_t_bps_sd_std_L1 ///
			c.VU#c.CE_10Y_t1_bps_sd_std_L1 ///
			c.FG_Change#c.VU#c.CE_3M_t_bps_sd_std_L1     ///
			c.FG_Change#c.VU#c.CE_3M_t1_bps_sd_std_L1    ///
			c.FG_Change#c.VU#c.CE_10Y_t_bps_sd_std_L1    ///
			c.FG_Change#c.VU#c.CE_10Y_t1_bps_sd_std_L1 ) ///
coeflabels(	FG_Change 									"(1) Forward guidance (FG) $\{-1,0,1\}$ change    " ///
			VU											"(2) Very unexpected FG change $\{0,1\}$" ///
			CE_3M_t_bps_sd_std_L1						"(3) Lagged interest rate disagreement ($\sigma_{t-1}$)" ///
			CE_3M_t1_bps_sd_std_L1						"(3) Lagged interest rate disagreement ($\sigma_{t-1}$)" ///
			CE_10Y_t_bps_sd_std_L1						"(3) Lagged interest rate disagreement ($\sigma_{t-1}$)" ///
			CE_10Y_t1_bps_sd_std_L1						"(3) Lagged interest rate disagreement ($\sigma_{t-1}$)" ///
			QE_Change 									"(4) Quantitative easing $\{-1,0,1\}$ change ($+1$)" ///
			c.FG_Change#c.VU			 				"(1) x (2)" ///
			c.FG_Change#c.CE_3M_t_bps_sd_std_L1			"(1) x (3)" ///
			c.FG_Change#c.CE_3M_t1_bps_sd_std_L1		"(1) x (3)" ///
			c.FG_Change#c.CE_10Y_t_bps_sd_std_L1		"(1) x (3)" ///
			c.FG_Change#c.CE_10Y_t1_bps_sd_std_L1		"(1) x (3)" ///
			c.VU#c.CE_3M_t_bps_sd_std_L1				"(2) x (3)" ///
			c.VU#c.CE_3M_t1_bps_sd_std_L1				"(2) x (3)" ///
			c.VU#c.CE_10Y_t_bps_sd_std_L1				"(2) x (3)" ///
			c.VU#c.CE_10Y_t1_bps_sd_std_L1				"(2) x (3)" ///
			c.FG_Change#c.VU#c.CE_3M_t_bps_sd_std_L1	"(1) x (2) x (3)"  ///
			c.FG_Change#c.VU#c.CE_3M_t1_bps_sd_std_L1	"(1) x (2) x (3)"  ///
			c.FG_Change#c.VU#c.CE_10Y_t_bps_sd_std_L1	"(1) x (2) x (3)"  ///
			c.FG_Change#c.VU#c.CE_10Y_t1_bps_sd_std_L1	"(1) x (2) x (3)" ) ///
title(\textbf{Unanticipated forward guidance, interest rate forecast disagreement, and the transmission of forward guidance} ///
\label{tab:VUDisagreement})	///
mtitles("[1]" "[2]" "[3]" "[4]") ///
addnote( ///
"Dependent variable [1]: revisions to individuals' forecasts, 3-month T-bill rate in 3 months (bps)." ///
"Dependent variable [2]: revisions to individuals' forecasts, 3-month T-bill rate in 12 months (bps)." ///
"Dependent variable [3]: revisions to individuals' forecasts, 10-year bond yield in 3 months (bps)." ///
"Dependent variable [4]: revisions to individuals' forecasts, 10-year bond yield in 12 months (bps)." ///
"Standard errors clustered at the country level. Regressions include both firm and month fixed effects." )
eststo clear
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE A17: How Forward Guidance Affected Interest Rate Expectations in Different Periods
****************************************************************************************************************************************************************************
eststo clear
*preserve
eststo: xtreg	CE_3M_t_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year<1999, fe vce(cluster country)
eststo: xtreg	CE_3M_t_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year>1998 & Year<2006, fe vce(cluster country)
eststo: xtreg	CE_3M_t_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year>2005 & Year<2013, fe vce(cluster country)
eststo: xtreg	CE_3M_t_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year>2012, fe vce(cluster country)
*restore

esttab using Table_FG_Subsamples_3M_t.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		FG_Change	) ///
coeflabels(	FG_Change			"Forward guidance (FG) $\{-1,0,1\}$ change" ///
						) ///
title(\textbf{How Forward Guidance Affected Interest Rate Expectations in Different Periods} ///
\label{tab:FGSS3Mt})	///
mtitles("[1]" "[2]" "[3]" "[4]") ///
addnote( ///
"[1]: 1990 to 1998; [2]: 1999 to 2005; [3]: 2006 to 2012; [4] 2013 to 2021." ///
"Dependent variable: revisions to individuals' forecasts, 3-month T-bill rate in 3 months (bps)." ///
"Regressions include all controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
*********************************************************************************************************************************



****************************************************************************************************************************************************************************
***TABLE A18: How Forward Guidance Affected Interest Rate Expectations in Different Periods
****************************************************************************************************************************************************************************
eststo clear
*preserve
eststo: xtreg	CE_10Y_t_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year<1999, fe vce(cluster country)
eststo: xtreg	CE_10Y_t_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year>1998 & Year<2006, fe vce(cluster country)
eststo: xtreg	CE_10Y_t_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year>2005 & Year<2013, fe vce(cluster country)
eststo: xtreg	CE_10Y_t_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year>2012, fe vce(cluster country)
*restore

esttab using Table_FG_Subsamples_10Y_1.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		FG_Change	) ///
coeflabels(	FG_Change			"Forward guidance (FG) $\{-1,0,1\}$ change" ///
						) ///
title(\textbf{How Forward Guidance Affected Interest Rate Expectations in Different Periods} ///
\label{tab:FGSS10Yt})	///
mtitles("[1]" "[2]" "[3]" "[4]") ///
addnote( ///
"[1]: 1990 to 1998; [2]: 1999 to 2005; [3]: 2006 to 2012; [4] 2013 to 2021." ///
"Dependent variable: revisions to individuals' forecasts, 10-year bond yield in 3 months (bps)." ///
"Regressions include all controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE A19: How Forward Guidance Affected Interest Rate Expectations in Different Periods
****************************************************************************************************************************************************************************
eststo clear
*preserve
eststo: xtreg	CE_10Y_t1_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year<1999, fe vce(cluster country)
eststo: xtreg	CE_10Y_t1_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year>1998 & Year<2006, fe vce(cluster country)
eststo: xtreg	CE_10Y_t1_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year>2005 & Year<2013, fe vce(cluster country)
eststo: xtreg	CE_10Y_t1_D1_bps	FG_Change CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if Year>2012, fe vce(cluster country)
*restore

esttab using Table_FG_Subsamples_10Y_t1.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep(		FG_Change	) ///
coeflabels(	FG_Change			"Forward guidance (FG) $\{-1,0,1\}$ change" ///
						) ///
title(\textbf{How Forward Guidance Affected Interest Rate Expectations in Different Periods} ///
\label{tab:FGSS10Yt1})	///
mtitles("[1]" "[2]" "[3]" "[4]") ///
addnote( ///
"[1]: 1990 to 1998; [2]: 1999 to 2005; [3]: 2006 to 2012; [4] 2013 to 2021." ///
"Dependent variable: revisions to individuals' forecasts, 10-year bond yield in 12 months (bps)." ///
"Regressions include all controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
*********************************************************************************************************************************


****************************************************************************************************************************************************************************
***TABLE Referee 1: Forward Guidance Horizon
****************************************************************************************************************************************************************************
bysort firm (mdate): 			g  FG_HDR_D1 = D1.FG_HDR
bysort firm (mdate): 			g  FG_HDR_YRS = FG_HDR / 365
bysort firm (mdate): 			g  FG_HDR_YRS_D1 = D1.FG_HDR_YRS

eststo clear
eststo: xtreg		CE_3M_t1_D1_bps		c.FG_Change##c.FG_HDR_YRS	CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate)					, fe vce(cluster country)
eststo: xtreg		CE_3M_t1_D1_bps		c.FG_Change##c.FG_HDR_YRS	CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if FG_HDR_YRS!=0	, fe vce(cluster country)
eststo: xtreg		CE_3M_t1_D1_bps		FG_HDR_YRS					CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate) if FG_HDR_YRS!=0	, fe vce(cluster country)
eststo: xtreg		CE_3M_t1_D1_bps		FG_HDR_YRS_D1 				CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 QE_Change ELB i.(mdate)					, fe vce(cluster country)


esttab using Table_FG_Horizon.tex, ///
replace b(2) ar2(2) noomitted nonumbers abs obslast gaps se compress star(* 0.10 ** 0.05 *** 0.01) ///
keep( FG_Change FG_HDR_YRS FG_HDR_YRS_D1 c.FG_Change#c.FG_HDR_YRS CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 PR_D1_x4 	QE_Change  ///
			) ///
coeflabels(	///
			FG_Change									"(1) FG $\{-1,0,1\}$ change" ///
			FG_HDR_YRS									"(2) FG horizon (years remaining)" ///
			FG_HDR_YRS_D1 								"(3) FG horizon first difference" ///
			c.FG_Change#c.FG_HDR_YRS					"(1) x (2)" ///
			CE_CPI_WA_D1_x4  							"Indiv. $\pi$ rev. (+25 bps)" ///
			CE_GDP_WA_D1_x4  							"Indiv. GDP g rev. (+25 bps)" ///
			PR_D1_x4 									"CB rate change (+25 bps)" ///
			QE_Change 									"QE $\{-1,0,1\}$ change ($+1$)" ///
			) ///
title(\textbf{Private-Sector Interest Rate Forecast Revisions and Forward Guidance Horizons} ///
\label{tab:FGHDR}) ///
mtitles("[1]" "[2]" "[3]" "[4]") ///
addnote( ///
"Dependent variable [1]: revisions to individuals' forecasts of the 3-month T-bill rate in 12 months (bps)." ///
"Dependent variable [2]: same as [1] but sample restricted to periods in which there were FG horizons only." ///
"Dependent variable [3]: same as [1] but sample restricted to periods in which there were FG horizons only." ///
"Dependent variable [4]: revisions to individuals' forecasts of the 3-month T-bill rate in 12 months (bps)." ///
"Regressions [1]-[4] include the controls from \autoref{eqn:Benchmark}. Standard errors clustered at the country level." )
eststo clear
****************************************************************************************************************************************************************************







	







*********************************************************************************************************************************
********* Install relevant packages for the empirical work below
ssc install reghdfe
ssc install xtscc
ssc install ftools
ssc install xtabond2
ssc install coefplot
ssc install winsor
*?not working for some reason? ssc install estout
*********************************************************************************************************************************


**************************************************************************************************
*******TABLE A19i: Summmary Statistics 1 ******
eststo clear
eststo: quietly estpost summarize FG_Change FG_abs FG_ODYSSEAN_abs FG_TC_abs FG_SC_abs FG_Q_abs QE_Change ELB CB_PolicyRate_P ///
PR_D1_bps CE_3M_t1_D1_bps CE_CPI_WA_D1_bps CE_GDP_WA_D1_bps,																																										///
listwise
esttab using SummaryStats.tex, replace cells("mean(fmt(2)) sd(fmt(2)) count(fmt(0)) min(fmt(0)) max(fmt(0))") ///	
	title("\textbf{Summary statistics: central bank policy changes and private-sector forecast revisions\label{tabStats}}")	///
	coeflabels(FG_Change 	"Forward guidance $\{-1,0,1\}$ change" ///
		FG_abs 				"Forward guidance $\{0,1\}$" ///
		FG_ODYSSEAN_abs		"Odyssean forward guidance $\{0,1\}$" ///
		FG_TC_abs			"Time-contingent forward guidance $\{0,1\}$" ///
		FG_SC_abs			"State-contingent forward guidance $\{0,1\}$" ///
		FG_Q_abs			"Qualitative forward guidance $\{0,1\}$" ///
		CB_PolicyRate_P		"Central bank policy rate projection $\{0,1\}$" ///
		QE_Change 			"Quantitative easing $\{-1,0,1\}$ change" ///
		ELB 				"Effective lower bound $\{0,1\}$" ///
		PR_D1_bps 			"Policy rate change (basis points (bps))" ///
		CE_3M_t1_D1_bps 	"Private T-bill forecast revision, 12-month horizon (bps)" ///
		CE_CPI_WA_D1_bps 	"Private inflation forecast revision, pseudo-12 mo horizon (bps)" ///
		CE_GDP_WA_D1_bps	"Private growth forecast revision, pseudo 12-mo horizon (bps)" ///
			)																																	
eststo clear																																									
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

*******TABLE A19ii: Summmary Statistics 2 ******
eststo clear
eststo: quietly estpost summarize CE_3M_t_D1_bps CE_10Y_t_D1_bps CE_10Y_t1_D1_bps,																																										///
listwise
esttab using SummaryStats.tex, replace cells("mean(fmt(2)) sd(fmt(2)) count(fmt(0)) min(fmt(0)) max(fmt(0))") ///	
	title("\textbf{Summary statistics: central bank policy changes and private-sector forecast revisions\label{tabStats}}")	///
	coeflabels(CE_3M_t_D1_bps 	"Private T-bill forecast revision, 3-month horizon (bps)" ///
		CE_10Y_t_D1_bps 		"Private bond yield forecast revision, 3-month horizon (bps)" ///
		CE_10Y_t1_D1_bps 		"Private bond yield forecast revision, 12-month horizon (bps)" ///
				)																																	
eststo clear																																									
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

*******TABLE A19iii: Summmary Statistics 3 ******
eststo clear
eststo: quietly estpost summarize CE_UR_WA_D1_bps,																																										///
listwise
esttab using SummaryStats.tex, replace cells("mean(fmt(2)) sd(fmt(2)) count(fmt(0)) min(fmt(0)) max(fmt(0))") ///	
	title("\textbf{Summary statistics: central bank policy changes and private-sector forecast revisions\label{tabStats}}")	///
	coeflabels(	CE_UR_WA_D1_bps 	"Private unemployment forecast rev., 12-mo horizon (bps)" ///
				)																																	
eststo clear																																									
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

*******TABLE A19iv: Summmary Statistics 4 ******
eststo clear
eststo: quietly estpost summarize CB_CPI_WA_D1_bps CB_GDP_WA_D1_bps,																																										///
listwise
esttab using SummaryStats.tex, replace cells("mean(fmt(2)) sd(fmt(2)) count(fmt(0)) min(fmt(0)) max(fmt(0))") ///	
	title("\textbf{Summary statistics: central bank policy changes and private-sector forecast revisions\label{tabStats}}")	///
	coeflabels(	CB_CPI_WA_D1_bps 			"CB inflation projection rev., pseudo 12-mo horizon (bps)" ///
				CB_GDP_WA_D1_bps 			"CB growth projection rev., pseudo 12-mo horizon (bps)" ///
				)																																	
eststo clear																																									
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

*******TABLE A19iv: Summmary Statistics 5 ******
eststo clear
eststo: quietly estpost summarize CB_PR_t_D1_bps CB_PR_t1_D1_bps,																																										///
listwise
esttab using SummaryStats.tex, replace cells("mean(fmt(2)) sd(fmt(2)) count(fmt(0)) min(fmt(0)) max(fmt(0))") ///	
	title("\textbf{Summary statistics: central bank policy changes and private-sector forecast revisions\label{tabStats}}")	///
	coeflabels(	CB_PR_t_D1_bps  			"CB policy rate projection rev., 12-mo horizon (bps)" ///
				CB_PR_t1_D1_bps  			"CB policy rate projection rev., 24-mo horizon (bps)" ///
				)																																	
eststo clear																																									
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

*******TABLE A19v: Summmary Statistics 6 ******
eststo clear
eststo: quietly estpost summarize VU CE_3M_t1_bps_sd_L1, ///
listwise
esttab using SummaryStats.tex, replace cells("mean(fmt(2)) sd(fmt(2)) count(fmt(0)) min(fmt(0)) max(fmt(0))") ///	
	title("\textbf{Summary statistics: central bank policy changes and private-sector forecast revisions\label{tabStats}}")	///
	coeflabels(	VU						"Very unexpected forward guidance change $\{0,1\}$" ///
	CE_3M_t1_bps_sd_L1					"First lag, SD, T-bill forecast revision, 12-mo horizon" /// 
		) 																																	
eststo clear																																									
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


***********************************************************************************************************************************************************
***Identification assumptions (~p. 20), theta-hat on the lagged dependent variable equals -0.18.
xtreg		CE_3M_t1_D1_bps		L1.CE_3M_t1_D1_bps FG_Change PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 QE_Change ELB i.(mdate), fe vce(cluster country)
***********************************************************************************************************************************************************

***********************************************************************************************************************************************************
***Results section (~p.25), standard errors robustness checks
***The results are robust to Driscoll and Kraay standard errors
ssc install xtscc
xtscc	CE_3M_t1_D1_bps		FG_Change 	PR_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4	ELB 	QE_Change 	i.(mdate), fe
***The results are robust to bootstrapped standard errors
set seed 277
*277 = CSS
xtreg	CE_3M_t1_D1_bps		FG_Change 	PR_D1_x4 	CE_CPI_WA_D1_x4 	CE_GDP_WA_D1_x4	ELB 	QE_Change 	i.(mdate), fe vce(bootstrap)
***********************************************************************************************************************************************************



///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////						
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////						
****************************************************** 8. FIGURES presented in the paper AND online appendix **************************************************
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////						
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////						

format 	mdate %tm
*set scheme s2mono
**format 	mdate %tmYY
set scheme s2color
		
***********************************************************************************************************************************************************************	
****FIGURE 1: Forward guidance******
*******Formatting note: outline with, vvv. thin; different outline colour, white.
twoway  (bar 	 FG_Change 			mdate, yaxis(1) color(gs13)) ///
		(scatter CE_3M_t1_D1_bps 	mdate, yaxis(2) msymbol(smcircle) msize(tiny) mcolor(gs9)) ///
		(scatter PR_D1_bps	 		mdate, yaxis(2) msymbol(smcircle) msize(tiny) mcolor(black)),  ///
		legend( ///
		label(1 "Forward guidance change {-1,0,1} (LHS)") ///
		label(2 "Interest rate forecast revision (12-month horizon) (basis points (bps), RHS)") ///
		label(3 "Central bank policy rate change (bps, RHS)") ///
		cols(1) symysize(1) symxsize(1) size(2) region(lpattern(blank) color(none) lcolor(none)) span)		///
		ysize(8) xsize(6) ///
		xtitle("", axis(1) size(tiny))												///
		ytitle("Forward guidance change {-1,0,1}", axis(1) size(vsmall) margin(small))	///	
		ytitle("Interest rate change (basis points)", axis(2) size(vsmall) margin(small))	///
		tlabel(1990m1(60)2021m4, labsize(small) angle(45))									///
		ylabel(-1(1)1, axis(1) nogrid labsize(small) )  ///
		ylabel(-400(400)400, axis(2) nogrid labsize(small) )  ///
		subtitle(, fcolor(white) lcol(white)) ///
		by(country,		///
			subtitle("", bcolor(white) size(tiny)) ///
			title("", bcolor(white)) ///
			graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)   	) 																	///
			note("Monthly Data, January 1990 to April 2021", pos(6) size(vsmall)) 						///
			plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)  )																	///
			legend(width(200) symysize(2) symxsize(2) size(2) region(lpattern(blank) subtitle(bgcolor(white)) color(white) lcolor(white)) span) 												///
			bgcolor(white) cols(3)) 							

graph export "C:\Users\sutc\Desktop\Attention to Forward Guidance\JAE\Manuscript and OA\Figure_1.png", as(png) name("Graph")
***********************************************************************************************************************************************************************


***********************************************************************************************************************************************************************	
****FIGURE SWP1: Forward guidance******
*******Formatting note: outline with, vvv. thin; different outline colour, white.
twoway  (bar 	 FG_Change 			mdate, yaxis(1) color(gs12)) ///
		(scatter CE_3M_t1_D1_bps 	mdate if FG_DELPHIC==0 & FG_ODYSSEAN==0, yaxis(2) msize(tiny) mcolor(eltblue)) ///
		(scatter CE_3M_t1_D1_bps 	mdate if FG_DELPHIC==-1, yaxis(2) msize(tiny) mcolor(ebblue)) ///
		(scatter CE_3M_t1_D1_bps 	mdate if FG_DELPHIC==1, yaxis(2) msize(tiny) mcolor(eltgreen)) ///
		(scatter CE_3M_t1_D1_bps 	mdate if FG_ODYSSEAN==-1, yaxis(2) msize(tiny) mcolor(erose)) ///
		(scatter PR_D1_bps	 		mdate, yaxis(2) msize(vtiny) mcolor(edkblue)),  ///
		legend( ///
		label(1 "Forward guidance change {-1,0,1} (LHS)") ///
		label(2 "Interest rate forecast revision (12-month horizon), no forward guidance (basis points (bps), RHS)") ///
		label(3 "Interest rate forecast revision (12-month horizon), dovish forward guidance, no commitment (bps, RHS)") ///
		label(4 "Interest rate forecast revision (12-month horizon), hawkish forward guidance, no commitment (bps, RHS)") ///
		label(5 "Interest rate forecast revision (12-month horizon), dovish forward guidance, with commitment (bps, RHS)") ///
		label(6 "Central bank policy rate change (bps, RHS)") ///
		cols(1) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span)		///
		ysize(8) xsize(6) ///
		xtitle("", axis(1) size(tiny))												///
		ytitle("Basis points", axis(2) size(tiny))	///	
		ytitle("Change in forward guidance", axis(1) size(tiny))	///	
		tlabel(1990m1(60)2021m4, labsize(small) angle(45))									///
		ylabel(-1(1)1, axis(1) nogrid labsize(small) )  ///
		ylabel(-400(400)400, axis(2) nogrid labsize(small) )  ///
		subtitle(, fcolor(white) lcol(white)) ///
		by(country,		///
		subtitle("", size(tiny)) ///
			graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)   	) 																	///
			note("Monthly Data, January 1990 to April 2021", pos(6) size(tiny)) 						///
			plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none) 		)																	///
			legend(width(200) symysize(2) symxsize(2) size(2)  region(lpattern(blank) color(none) lcolor(none)) span) 												///
			bgcolor(white) cols(3)) 									
***********************************************************************************************************************************************************************


***********************************************************************************************************************************************************************
***FIGURE 2: Country-by-country panel regressions (3M in 12M)
*******Formatting note: outline width, vvv. thin; different outline colour, white.
eststo clear
local cntry `" "USA" "UK" "Canada" "Australia" "NewZealand" "Germany" "France" "Italy" "'
foreach country in `cntry'	{
xtreg	CE_3M_t1_D1_bps	FG_Change FG_Change_Fed PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 CE_UR_WA_D1_x4 QE_Change ELB dmonthnum* i.(Year) if country == "`country'", fe vce(cluster firm)
estimates store `country'   
}
local cntry `" "Netherlands" "Spain" "Norway" "Sweden" "'
foreach country in `cntry'	{
xtreg	CE_3M_t1_D1_bps	FG_Change FG_Change_Fed PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 				QE_Change ELB dmonthnum* i.(Year) if country == "`country'", fe vce(cluster firm)
estimates store `country'   
}
coefplot "USA" "UK" "Canada" "Australia" "NewZealand" "Germany" "France" "Italy" "Netherlands" "Spain" "Norway" "Sweden", ///
keep(FG_Change  FG_Change_Fed PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 CE_UR_WA_D1_x4) xline(0) ///
coeflabels(		FG_Change = "Forward guidance {-1,0,1} change (+1)" ///
				FG_Change_Fed = "FOMC FG {-1,0,1} change (+1)" ///
				PR_D1_x4 = "Policy rate change (+25 bps)" ///
				CE_CPI_WA_D1_x4 = "Private inflation revision (+25 bps)" ///
				CE_GDP_WA_D1_x4 = "Private GDP growth revision (+25 bps)" ///
				CE_UR_WA_D1_x4 = "Private unemployment revision (+25 bps)" ) ///
ysize(8) xsize(6) ///
ytitle("Coefficients of interest from panel regressions", size(vsmall))	///		
xtitle("Revisions to forecasts of the 3-month T-bill rate in 12 months in basis points (bps)", size(vsmall))		
/// To edit the appearance of the graph for papers and decks, create the graph, click the graph editor icon, double-click the graph to bring up graph properties.
***********************************************************************************************************************************************************************


**************************************************************************************************
**Slide Deck: D1: Canada only**
twoway  (bar FG_Change mdate if country=="Canada", yaxis(1) color(gs12)) ///
		(scatter CE_3M_t1_D1_bps mdate if FG_DELPHIC==0 & FG_ODYSSEAN==0 & country=="Canada", yaxis(2) msize(tiny) mcolor(eltblue)) ///
		(scatter CE_3M_t1_D1_bps mdate if FG_DELPHIC==-1 & country=="Canada", yaxis(2) msize(tiny) mcolor(ebblue)) ///
		(scatter CE_3M_t1_D1_bps mdate if FG_DELPHIC==1 & country=="Canada", yaxis(2) msize(tiny) mcolor(eltgreen)) ///
		(scatter CE_3M_t1_D1_bps mdate if FG_ODYSSEAN==-1 & country=="Canada", yaxis(2) msize(tiny) mcolor(erose)) ///
		(scatter PR_D1_bps 		 mdate if country=="Canada", yaxis(2) msize(tiny) mcolor(edkblue)),  ///
		legend( ///
		label(1 "Forward guidance change {-1,0,1} (LHS)") ///
		label(2 "Policy rate forecast (12-month horizon), no forward guidance (bps, RHS)") ///
		label(3 "Policy rate forecast (12-month horizon), dovish Delphic forward guidance (bps, RHS)") ///
		label(4 "Policy rate forecast (12-month horizon), hawkish Delphic forward guidance (bps, RHS)") ///
		label(5 "Policy rate forecast (12-month horizon), dovish Odyssean forward guidance (bps, RHS)") ///
		label(6 "Central bank policy rate (bps, RHS)") ///
		cols(1) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span)		///
		xtitle("", axis(1) size(tiny))												///
		ytitle("Forward guidance change {-1,0,1}", axis(1) size(small) margin(medium))	///	
		ytitle("Interest rate change (basis points)", axis(2) size(small) margin(medium))	///
		tlabel(1990m1(24)2020m5, labsize(small) angle(45))									///
		ylabel(-1(1)1, nogrid labsize(small) )									///
		subtitle(, fcolor(white) lcol(white)) ///
		graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)) /// 	
		note("Monthly Data, January 1990 to May 2020", pos(6) size(tiny)) ///
		plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)) ///
		legend(width(200) symysize(2) symxsize(2) size(2)  region(lpattern(blank) color(none) lcolor(none)) span) ///
		bgcolor(white)
**************************************************************************************************

				
**********************************************************************************************************************************************************************
****FIGURE A2 (Online Appendix): Show the data by change in forward guidance change value
twoway     scatter CE_3M_t1_D1_bps CE_CPI_WA_D1_bps if FG_Change == 0, msymbol(smcircle)  msize(tiny) mcolor(ebg)	///
		|| scatter CE_3M_t1_D1_bps CE_CPI_WA_D1_bps if FG_Change == 1, msymbol(smcircle) msize(tiny) mcolor(edkblue)  ///
		|| scatter CE_3M_t1_D1_bps CE_CPI_WA_D1_bps if FG_Change == -1, msymbol(smcircle) msize(tiny) mcolor(erose) 	///
		legend(label(1 "No change in forward guidance (0)") ///
		label(2 "Hawkish change in forward guidance (+1)") ///
		label(3 "Dovish change in forward guidance (-1)") ///
		cols(1) width(200) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span)		///
		xline(0) yline(0) ///
		ysize(8) xsize(6) ///
		ytitle("12-month interest rate forecast revision (bps)", size(vsmall))	///		
		xtitle("12-month inflation forecast revision (bps)", size(vsmall) axis(1))	///
		subtitle(, fcolor(white) lcol(white)) ///
		by(country,		///
		subtitle("", size(small)) ///
			note("", size(vsmall)) 						///
			graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)   	) 																	///
			plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none) 		)																	///
			legend(cols(1) width(200) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span) 												///
			bgcolor(white) cols(3)) 
**********************************************************************************************************************************************************************


**********************************************************************************************************************************************************
****FIGURE A3 (Online Appendix): Show the data by change in forward guidance change value (Split by commitment-based and non-commitment-based forward guidance)
twoway     scatter CE_3M_t1_D1_bps CE_CPI_WA_D1_bps if FG_Change == -1 & FG_DELPHIC ==-1, msymbol(smcircle) msize(tiny) mcolor(ebblue)	///
		|| scatter CE_3M_t1_D1_bps CE_CPI_WA_D1_bps if FG_Change == 1  & FG_DELPHIC ==1, msymbol(smcircle) msize(tiny) mcolor(eltgreen)  	///
		|| scatter CE_3M_t1_D1_bps CE_CPI_WA_D1_bps if FG_Change == -1 & FG_ODYSSEAN ==-1, msymbol(smcircle) msize(tiny) mcolor(erose) 	///
		legend(label(1 "Dovish change in forward guidance (no commitment)") ///
		label(2 "Hawkish change in forward guidance (no commitment)") ///
		label(3 "Dovish change in forward guidance (commitment)") ///
		cols(1) width(200) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span)		///
		xline(0) yline(0) ///
		ysize(8) xsize(6) ///
		ytitle("Interest rate forecast revision (bps)", size(vsmall))	///		
		xtitle("Inflation forecast revision (bps)", size(vsmall) axis(1))	///
		subtitle(, fcolor(white) lcol(white)) ///
		by(country,		///
		subtitle("", size(small)) ///
			note("", size(vsmall)) 						///
			graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)   	) 																	///
			plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none) 		)																	///
			legend(width(200) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span) 												///
			bgcolor(white) cols(3)) 									
		
		// || scatter CE_3M_t1_D1 CE_CPI_t_D1 if FG_Change == 1  & FG_ODYSSEAN !=0, msize(tiny) mcolor(red)   ///
		//ylabel(-2(2)2, nogrid labsize(small) )									///
		//xscale(range(-2 2))	///
		//yscale(range(-2 2))	///
**********************************************************************************************************************************************************


**********************************************************************************************************************************************************
****FIGURE A4 (Online Appendix): Show the regressions by forward guidance attribute (state-contingent and time-contingent)
twoway     scatter CE_3M_t1_D1_bps CE_CPI_WA_D1_bps if FG_Change == -1 & FG_TC ==-1, msymbol(smcircle) msize(tiny) mcolor(eltblue)	///
		|| scatter CE_3M_t1_D1_bps CE_CPI_WA_D1_bps if FG_Change == 1  & FG_TC ==1, msymbol(smcircle) msize(tiny) mcolor(edkblue)  ///
		|| scatter CE_3M_t1_D1_bps CE_CPI_WA_D1_bps if FG_Change == -1 & FG_SC ==-1, msymbol(smcircle) msize(tiny) mcolor(erose) 	///
		|| scatter CE_3M_t1_D1_bps CE_CPI_WA_D1_bps if FG_Change == 1  & FG_SC ==1, msymbol(smcircle) msize(tiny) mcolor(maroon) 	///
		legend(label(1 "Dovish change in FG (Time-contingent)") ///
		label(2 "Hawkish change in FG (Time-contingent)") ///
		label(3 "Dovish change in FG (State-contingent)") ///
		label(4 "Hawkish change in FG (State-contingent)") ///
		cols(1) width(200) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span)		///
		xline(0) yline(0) ///
		ysize(8) xsize(6) ///
		ytitle("Interest rate forecast revision (bps)", size(vsmall))	///		
		xtitle("Inflation forecast revision (bps)", size(vsmall) axis(1))	///
		subtitle(, fcolor(white) lcol(white)) ///
		by(country,		///
		subtitle("", size(small)) ///
			note("", size(vsmall)) 						///
			graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)   	) 																	///
			plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none) 		)																	///
			legend(width(200) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span) 												///
			bgcolor(white) cols(3)) 									
		
		*|| scatter CE_3M_t1_D1_bps CE_CPI_t_D1_bps if FG_Change == -1 & FG_Q ==-1, msize(tiny) mcolor(mint) 	///
		*|| scatter CE_3M_t1_D1_bps CE_CPI_t_D1_bps if FG_Change == 1  & FG_Q ==1, msize(tiny) mcolor(midgreen) 	///
		*label(5 "Dovish change in forward guidance (Qualitative)") ///
		*label(6 "Hawkish change in forward guidance (Qualitative)") //
**********************************************************************************************************************************************************


**********************************************************************************************************************************************************
***FIGURE A5 (Online Appendix): Quantitative easing*****
twoway  (bar 	 QE_Change mdate, yaxis(1) color(gs13)) ///
		(scatter CE_3M_t1_D1_bps mdate, yaxis(2) msymbol(circle) msize(tiny) mcolor(eltblue)) ///
		(scatter PR_D1_bps mdate, 		yaxis(2) msymbol(circle) msize(tiny) mcolor(edkblue)),  ///
		legend( ///
		label(1 "Quantitative easing change {-1,0,1} (LHS)") ///
		label(2 "Interest rate forecast revision (12-month horizon) (basis points (bps), RHS)") ///
		label(3 "Central bank policy rate change (bps, RHS)") ///
		cols(1) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span)		///
		ysize(8) xsize(6) ///
		xtitle("", axis(1) size(tiny))												///
		ytitle("Quantitative easing  change {-1,0,1}", axis(1) size(vsmall) margin(small))	///	
		ytitle("Interest rate change (basis points)", axis(2) size(vsmall) margin(small))	///
		tlabel(1990m1(60)2021m4, labsize(small) angle(45))									///
		ylabel(-1(1)1, axis(1) nogrid labsize(small) )  ///
		ylabel(-400(400)400, axis(2) nogrid labsize(small) )  ///
		subtitle(, fcolor(white) lcol(white)) ///
		by(country,		///
			subtitle("", bcolor(white) size(tiny)) ///
			title("", bcolor(white)) ///
			graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)   	) 																	///
			note("Monthly Data, January 1990 to April 2021", pos(6) size(vsmall)) 						///
			plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)  )																	///
			legend(width(200) symysize(2) symxsize(2) size(2) region(lpattern(blank) subtitle(bgcolor(white)) color(white) lcolor(white)) span) 												///
			bgcolor(white) cols(3)) 									
**********************************************************************************************************************************************************


**************************************************************************************************************************************************
***FIGURE A6: A graphical depiction of how individual data offers so much more than mean data (Online appendix)
twoway     scatter CE_3M_t1_D1_bps 		mdate, msymbol(circle) msize(tiny) mcolor(ebg)	///
		|| scatter CE_3M_t1_D1_bps_mean	mdate, msymbol(circle) msize(tiny) mcolor(edkblue)  ///
		legend(label(1 "Individual revision to the forecast of the 3-month T-bill rate in 12 months (bps)") ///
		label(2 "Mean revision to the forecast of the 3-month T-bill rate in 12 months (bps)") ///
		cols(1) width(200) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span)		///
		yline(0) ///
		ysize(8) xsize(6) ///
		ytitle("12-month T-bill forecast revision (bps)", size(vsmall))	///		
		xtitle("Monthly Data", size(vsmall) axis(1))	///
		tlabel(1990m1(48)2020m5, labsize(small) angle(45))									///
		subtitle(, fcolor(white) lcol(white)) ///
		by(country,		///
		subtitle("", size(tiny)) ///
			note("Each light-blue dot represents an individual forecaster's forecast revision.", size(vsmall)) 						///
			graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)   	) 																	///
			plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none) 		)																	///
			legend(width(200) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span) 												///
			bgcolor(white) cols(3))	
**************************************************************************************************************************************************



***********************************************************************************************************************************************************************	
****FIGURE A7: CE vs CB CPI******
*******Formatting note: outline with, vvv. thin; different outline colour, white.
twoway  (scatter CE_CPI_WA_D1_bps 	mdate, msymbol(circle) msize(tiny) mcolor(eltblue)) ///
		(scatter CB_CPI_WA_D1_bps 	mdate, msymbol(circle) msize(tiny) mcolor(edkblue)), ///
		legend(label(1 "Private-sector inflation forecast revision (bps)") ///
		label(2 "Central bank inflation forecast revision (bps)") ///
		cols(1) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span)		///
		ysize(8) xsize(6) ///
		xtitle("", axis(1) size(tiny))												///
		ytitle("12-month CPI forecast revision (bps)", size(vsmall))	///	
		tlabel(1990m1(60)2021m4, labsize(small) angle(45))									///
		ylabel(-500(500)500, nogrid labsize(small) )  ///
		subtitle(, fcolor(white) lcol(white)) ///
		by(country,		///
		subtitle("", size(tiny)) ///
			graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)   	) 																	///
			note("Monthly Data, January 1990 to April 2021", pos(6) size(vsmall)) 						///
			plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none) 		)																	///
			legend(width(200) symysize(2) symxsize(2) size(2)  region(lpattern(blank) color(none) lcolor(none)) span) 												///
			bgcolor(white) cols(3)) 			
graph export "C:\Users\sutc\Desktop\Attention to Forward Guidance\JAE\Manuscript and OA\forecasts_growth_PS_vs_CB.png", as(png) name("Graph")
***********************************************************************************************************************************************************************


***********************************************************************************************************************************************************************	
****FIGURE A8: CE vs CB GDP******
*******Formatting note: outline with, vvv. thin; different outline colour, white.
twoway  (scatter CE_GDP_WA_D1_bps 	mdate, msymbol(circle) msize(tiny) mcolor(eltblue)) ///
		(scatter CB_GDP_WA_D1_bps 	mdate, msymbol(circle) msize(tiny) mcolor(edkblue)), ///
		legend(label(1 "Private-sector domestic growth forecast revision (bps)") ///
		label(2 "Central bank domestic growth forecast revision (bps)") ///
		cols(1) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span)		///
		ysize(8) xsize(6) ///
		xtitle("", axis(1) size(tiny))												///
		ytitle("Interest rate forecast revision (bps)", size(vsmall))	///
		tlabel(1990m1(60)2021m4, labsize(small) angle(45))									///
		ylabel(-2000(1000)2000, nogrid labsize(small) )  ///
		subtitle(, fcolor(white) lcol(white)) ///
		by(country,		///
		subtitle("", size(tiny)) ///
			graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)   	) 																	///
			note("Monthly Data, January 1990 to April 2021", pos(6) size(vsmall)) 						///
			plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none) 		)																	///
			legend(width(200) symysize(2) symxsize(2) size(2)  region(lpattern(blank) color(none) lcolor(none)) span) 												///
			bgcolor(white) cols(3)) 									
***********************************************************************************************************************************************************************


***********************************************************************************************************************************************************************	
****FIGURE A9: CE vs CB PR******
*******Formatting note: outline with, vvv. thin; different outline colour, white.
twoway  (scatter CE_3M_t1_D1_bps mdate, msymbol(circle) msize(tiny) mcolor(eltblue)) ///
		(scatter CB_PR_WA_D1_bps mdate, msymbol(circle) msize(tiny) mcolor(edkblue)), ///
		legend(label(1 "Private-sector interest rate forecast revision (12-month horizon) (bps)") ///
		label(2 "Central bank policy rate forecast revision (bps)") ///
		cols(1) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span)		///
		ysize(8) xsize(6) ///
		xtitle("", axis(1) size(tiny))												///
		ytitle("12-month interest rate forecast revision (bps)", size(vsmall))	///	
		tlabel(1990m1(60)2021m4, labsize(small) angle(45))									///
		ylabel(-500(500)500, nogrid labsize(small) )  ///
		subtitle(, fcolor(white) lcol(white)) ///
		by(country,		///
			subtitle("", size(tiny)) ///
			graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)   	) 																	///
			note("Monthly Data, January 1990 to April 2021", pos(6) size(vsmall)) 						///
			plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none) 		)																	///
			legend(width(200) symysize(2) symxsize(2) size(2)  region(lpattern(blank) color(none) lcolor(none)) span) 												///
			bgcolor(white) cols(3)) 	
			
graph export "C:\Users\sutc\Desktop\Attention to Forward Guidance\JAE\Manuscript and OA\forecasts_PR_PS_vs_CB.png", as(png) name("Graph")
***********************************************************************************************************************************************************************
	
	
***********************************************************************************************************************************************************************	
****FIGURE A10: Forward guidance FG_horizon******
*******Formatting note: outline with, vvv. thin; different outline colour, white.
twoway  (bar 	 FG_HDR 			mdate, yaxis(1) color(gs13)) ///
		(scatter CE_3M_t1_D1_bps 	mdate, yaxis(2) msymbol(smcircle) msize(tiny) mcolor(gs9)) ///
		(scatter PR_D1_bps	 		mdate, yaxis(2) msymbol(smcircle) msize(tiny) mcolor(black)),  ///
		legend( ///
		label(1 "Forward guidance horizon (days) (LHS)") ///
		label(2 "Interest rate forecast revision (12-month horizon) (basis points (bps), RHS)") ///
		label(3 "Central bank policy rate change (bps, RHS)") ///
		cols(1) symysize(1) symxsize(1) size(2) region(lpattern(blank) color(none) lcolor(none)) span)		///
		ysize(8) xsize(6) ///
		xtitle("", axis(1) size(tiny))												///
		ytitle("Forward guidance horizon (days)", axis(1) size(vsmall) margin(small))	///	
		ytitle("Interest rate change (basis points)", axis(2) size(vsmall) margin(small))	///
		tlabel(1990m1(60)2021m4, labsize(small) angle(45))									///
		ylabel(0(400)1600, axis(1) nogrid labsize(small) )  ///
		ylabel(-400(400)400, axis(2) nogrid labsize(small) )  ///
		subtitle(, fcolor(white) lcol(white)) ///
		by(country,		///
			subtitle("", bcolor(white) size(tiny)) ///
			title("", bcolor(white)) ///
			graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)   	) 																	///
			note("Monthly Data, January 1990 to April 2021", pos(6) size(vsmall)) 						///
			plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)  )																	///
			legend(width(200) symysize(2) symxsize(2) size(2) region(lpattern(blank) subtitle(bgcolor(white)) color(white) lcolor(white)) span) 												///
			bgcolor(white) cols(3)) 							

graph export "C:\Users\sutc\Desktop\Attention to Forward Guidance\JAE\Manuscript and OA\Figure_FG_horizon.png", as(png) name("Graph")
***********************************************************************************************************************************************************************


***********************************************************************************************************************************************************************	
****FIGURE A11.: Rate Forecasts in Levels******
*******Formatting note: outline with, vvv. thin; different outline colour, white.
preserve
drop if Year<2010
twoway  (bar 	 FG_Change 		mdate, yaxis(1) color(gs13)) ///
		(scatter CE_3M_t1_bps 	mdate, yaxis(2) msymbol(smcircle) msize(tiny) mcolor(gs9)) ///
		(scatter PR_bps	 		mdate, yaxis(2) msymbol(smcircle) msize(tiny) mcolor(black)),  ///
		legend( ///
		label(1 "Forward guidance change {-1,0,1} (LHS)") ///
		label(2 "Interest rate forecast (12-month horizon) (basis points (bps), RHS)") ///
		label(3 "Central bank policy rate (bps, RHS)") ///
		cols(1) symysize(1) symxsize(1) size(2) region(lpattern(blank) color(none) lcolor(none)) span)		///
		ysize(8) xsize(6) ///
		xtitle("", axis(1) size(tiny))												///
		ytitle("Forward guidance change {-1,0,1}", axis(1) size(vsmall) margin(small))	///	
		ytitle("Interest rate (basis points)", axis(2) size(vsmall) margin(small))	///
		tlabel(2010m1(24)2021m4, labsize(small) angle(45))									///
		ylabel(-1(1)1, axis(1) nogrid labsize(small) )  ///
		ylabel(-200(200)600, axis(2) nogrid labsize(small) )  ///
		subtitle(, fcolor(white) lcol(white)) ///
		by(country,		///
			subtitle("", bcolor(white) size(tiny)) ///
			title("", bcolor(white)) ///
			graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)   	) 																	///
			note("Monthly Data, January 2010 to April 2021", pos(6) size(vsmall)) 						///
			plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)  )																	///
			legend(width(200) symysize(2) symxsize(2) size(2) region(lpattern(blank) subtitle(bgcolor(white)) color(white) lcolor(white)) span) 												///
			bgcolor(white) cols(3)) 							
graph export "C:\Users\sutc\Desktop\Attention to Forward Guidance\JAE\Manuscript and OA\rate_forecasts_levels.png", as(png) name("Graph")				
restore
***********************************************************************************************************************************************************************



***********************************************************************************************************************************************************************
***FIGURE A##?: Country-by-country panel regressions (10Y in 12M)
*******Formatting note: outline with, vvv. thin; different outline colour, white.
eststo clear
local cntry `" "USA" "UK" "Canada" "Australia" "NewZealand" "Germany" "France" "Italy" "'
foreach country in `cntry'	{
xtreg	CE_10Y_t1_D1_bps	FG_Change FG_Change_Fed PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 CE_UR_WA_D1_x4 QE_Change ELB dmonthnum* i.(Year) if country == "`country'", fe vce(cluster firm)
estimates store `country'   
}
local cntry `" "Netherlands" "Spain" "Norway" "Sweden" "'
foreach country in `cntry'	{
xtreg	CE_10Y_t1_D1_bps	FG_Change FG_Change_Fed PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 				QE_Change ELB dmonthnum* i.(Year) if country == "`country'", fe vce(cluster firm)
estimates store `country'   
}
coefplot "USA" "UK" "Canada" "Australia" "NewZealand" "Germany" "France" "Italy" "Netherlands" "Spain" "Norway" "Sweden", ///
keep(FG_Change  FG_Change_Fed PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 CE_UR_WA_D1_x4) xline(0) ///
coeflabels(		FG_Change = "Forward guidance {-1,0,1} change (+1)" ///
				FG_Change_Fed = "FOMC FG {-1,0,1} change (+1)" ///
				PR_D1_x4 = "Policy rate change (+25 bps)" ///
				CE_CPI_WA_D1_x4 = "Private inflation revision (+25 bps)" ///
				CE_GDP_WA_D1_x4 = "Private GDP growth revision (+25 bps)" ///
				CE_UR_WA_D1_x4 = "Private unemployment revision (+25 bps)" ) ///
ytitle("Coefficients of interest from panel regressions", size(vsmall))	///		
xtitle("Revisions to forecasts of the 10-year T-bond yield in 12 months in basis points (bps)", size(vsmall))		
/// To edit the appearance of the graph for papers and decks, create the graph, click the graph editor icon, double-click the graph to bring up graph properties.
***********************************************************************************************************************************************************************






****************************************************************************************************************************************************************************************************
***FIGURE A## (Robustness Section): Placebo
eststo clear
tabulate FG_Change
set seed 277
*277 = CSS
sort $id $t
preserve
forvalues i=1(1)100 {
        generate 	u = runiform(0, 1)
		generate 	Placebo`i' = 0
		replace 	Placebo`i' = -1 if u<0.0341
		replace 	Placebo`i' = 1 	if u>0.9808
        xtreg		CE_3M_t1_D1_bps		Placebo`i' QE_Change PR_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 ELB i.(mdate), fe vce(cluster country)
		estimates 	store Placebo`i' 
		drop 		u
		drop 		Placebo`i'
        save 		sample`i', replace
        restore, 	preserve  
}
coefplot ("Placebo*", label(FG)), keep("Placebo*") xline(0) pstyle(p1) recast (scatter)
eststo clear

*runiformint(a, b)
*generate ui = floor((b–a+1)*runiform() + a)

*??
forvalues i = 1(1)9  {
xtreg		CE_3M_t1_D1_bps		FG_Placebo`i' QE_Change PR_D1_x4 CE_CPI_t_D1_x4 ELB i.(Year) dmonthnum* ln_monthnum, fe vce(cluster country)
estimates store Placebo`i'   
}
coefplot (("Placebo1", label()) "Placebo2" "Placebo3" "Placebo4" "Placebo5" "Placebo6" "Placebo7" "Placebo8" "Placebo9"), keep(FG_Placebo1 FG_Placebo2 FG_Placebo3 FG_Placebo4 FG_Placebo5 FG_Placebo6 FG_Placebo7 FG_Placebo8 FG_Placebo9) xline(0) pstyle(p1)
****************************************************************************************************************************************************************************************************


*************************************************************************************************************************************************************************************************************************	
***FIGURE A##: country-by-country panel regressions with CENTRAL BANK projections revisions (3M in 12M) (10Y in 12M)
eststo clear
local cntry `" "USA" "UK" "Canada" "Australia" "NewZealand" "Germany" "'
foreach country in `cntry'	{
xtreg	CE_3M_t1_D1_bps	FG_Change PR_D1_x4 CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 CE_UR_WA_D1_x4 	QE_Change ELB dmonthnum* i.(Year) if country == "`country'", fe vce(cluster firm)
estimates store `country'   
}
local cntry `" "Norway" "Sweden" "'
foreach country in `cntry'	{
xtreg	CE_3M_t1_D1_bps	FG_Change PR_D1_x4 CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 					QE_Change ELB dmonthnum* i.(Year) if country == "`country'", fe vce(cluster firm)
estimates store `country'   
}

coefplot "USA" "UK" "Canada" "Australia" "NewZealand" "Germany" "Norway" "Sweden", ///
keep(			FG_Change PR_D1_x4 CB_CPI_WA_D1_x4 CB_GDP_WA_D1_x4 CE_CPI_WA_D1_x4 CE_GDP_WA_D1_x4 CE_UR_WA_D1_x4) xline(0) ///
coeflabels(		FG_Change = "Forward guidance {-1,0,1} change (+1)" ///
				PR_D1_x4 = "Central bank policy rate change (+25 bps)" ///
				CE_CPI_WA_D1_x4 = "Individual inflation revision (+25 bps)" ///
				CE_GDP_WA_D1_x4 = "Individual GDP growth revision (+25 bps)" ///
				CE_UR_WA_D1_x4 = "Individual unemployment revision (+25 bps)" ///
				CB_CPI_WA_D1_x4 = "Central bank inflation revision (+25 bps)" ///
				CB_GDP_WA_D1_x4 = "Central bank GDP growth revision (+25 bps)" ) ///
ysize(8) xsize(6) ///
subtitle(, fcolor(white) lcol(white)) ///
ytitle("Coefficients of interest from panel regressions", size(vsmall))	///		
xtitle("Changes in private one-year policy rate forecasts in basis points (bps)", size(vsmall))		
/// To edit the appearance of the graph for papers and decks, create the graph, click the graph editor icon, double-click the graph to bring up graph properties.
*************************************************************************************************************************************************************************************************************************


*********************************************************************************************************************************
***FIGURE A##: Subsample analysis
*******Formatting note: outline with, vvv. thin; different outline colour, white. **set scheme s2mono
eststo clear
xtreg		CE_3M_t1_D1_bps		$xlist if Year>2012, fe vce(cluster country)
estimates store ModernEra
xtreg		CE_3M_t1_D1_bps		$xlist if Year>2005 & Year<2013, fe vce(cluster country)
estimates store CrisisEra
xtreg		CE_3M_t1_D1_bps		$xlist if Year>1998 & Year<2006, fe vce(cluster country)
estimates store NoughtiesEra
xtreg		CE_3M_t1_D1_bps		$xlist if Year<1999, fe vce(cluster country)
estimates store NinetiesEra
coefplot ("ModernEra", label(2013 to 2020)) ("CrisisEra", label(2006 to 2012)) ///
("NoughtiesEra", label(1999 to 2005)) ("NinetiesEra", label(1990 to 1998)), ///
keep(FG_Change  QE_Change PR_D1_x4 CE_CPI_WA_D1_x4 CE_CPI_WA_D1_x4) xline(0) ///
coeflabels( FG_Change = "Forward guidance {-1,0,1} change (+1)" ///
			QE_Change = "Quantitative easing {-1,0,1} change (+1)" ///
			PR_D1_x4 = "Policy rate change (+25 bps)" ///
			CE_CPI_WA_D1_x4 = "Indiv. inflation revision (+25 bps)" ///
			CE_GDP_WA_D1_x4 = "Indiv. GDP growth revision (+25 bps)") ///
ysize(8) xsize(6) ///
ytitle("Coefficients of interest from panel regressions", size(vsmall))	///		
xtitle("revisions to individuals' forecasts, 3-month T-bill rate in 12 months (bps)", size(vsmall))		
eststo clear
**********************************************************************************************************************************









**********************************************************************************************************************************************************************
****FIGURE A##? (Online Appendix?): CB Data
twoway  	scatter CB_CPI_WA_D1_bps CB_GDP_WA_D1_bps, msymbol(smcircle) msize(tiny) mcolor(edkblue) ///
		|| 	scatter CE_CPI_WA_D1_bps CE_GDP_WA_D1_bps, msymbol(smcircle) msize(tiny) mcolor(eltblue) ///
		legend(	label(1 "Central bank forecast revision (bps)") ///
		label(2 "Private-sector forecast revision (bps)") ///
		cols(1) width(200) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span)		///
		xline(0) yline(0) ///
		ysize(8) xsize(6) ///
		ytitle("12-month CPI forecast revision (bps)", size(vsmall)  margin(small))	///		
		xtitle("12-month GDP forecast revision (bps)", size(vsmall)  margin(small))	///
		subtitle(, fcolor(white) lcol(white)) ///
		by(country,		///
		subtitle("", size(small)) ///
			note("", size(vsmall)) 						///
			graphregion(color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none)   	) 																	///
			plotregion(	color(white) fcolor(white) lcolor(none) icolor(none)  ilcolor(none) ifcolor(none) 		)																	///
			legend(cols(1) width(200) symysize(1) symxsize(1) size(2)  region(lpattern(blank) color(none) lcolor(none)) span) 												///
			bgcolor(white) cols(3)) 
**********************************************************************************************************************************************************************





